@ECHO OFF
SETLOCAL
SET ERRORLEVEL=

ECHO This will delete your configuration files and re-download the XM6 packages.
ECHO.
PAUSE
ECHO.

:: Check if configuration files actually exist

IF EXIST XM6.INI  GOTO DEL_CONFIG
IF EXIST SRAM.DAT GOTO DEL_CONFIG
ECHO No configuration files found.
ECHO.
GOTO REINSTALL

:DEL_CONFIG

CALL :ASK No "Are you sure you want to delete your configuration files?"
IF %ERRORLEVEL% EQU 0 GOTO FINISHED

DEL/F XM6.INI  >NUL 2>NUL 
DEL/F SRAM.DAT >NUL 2>NUL 
IF EXIST XM6.INI  GOTO DEL_FAILED
IF EXIST SRAM.DAT GOTO DEL_FAILED

CLS
ECHO Configuration files deleted.
ECHO.
ECHO Please check if this fixed whatever problem precipitated this reinstall.
ECHO.
PAUSE
CLS

:REINSTALL

ECHO We will now re-download and extract the XM6 packages.
ECHO.
ECHO It is not normally necessary to do this unless files got moved or damaged.
ECHO.
CALL :ASK No "Are you sure you want to reinstall XM6 Pro-68k?"
IF %ERRORLEVEL% EQU 0 GOTO FINISHED

CLS
DEL/F >NUL 2>NUL Version.txt
IF EXIST Version.txt GOTO DEL_FAILED
"Scripts\Check for Updates.bat"

:ASK
SET DEF=%1
SET DISPLAY=%~2 [%DEF%] 
:RETRY
SET YN=
SET YN=%DEF%
SET/P YN=%DISPLAY%
:: Treat a single space followed by return/enter as the default selection
IF /I  "%YN%"==" " SET YN=%DEF%
IF NOT "%YN%"=="" (
SET YN=%YN:~0,1%
) ELSE SET YN=%DEF%
IF /I "%YN%"=="Q" EXIT
IF /I "%YN%"=="Y" GOTO VALID
IF /I "%YN%"=="N" GOTO VALID
ECHO.
ECHO Please enter yes or no (or the first letter of either) or q to quit.
ECHO A blank response will be interpreted as the default, which is "%DEF%" here.
ECHO.
:: Pause to give the user a chance to ^C instead. ^C doesn't work at the prompt.
PAUSE
ECHO.
GOTO RETRY
:VALID
ECHO.
IF /I "%YN%"=="Y" EXIT/B 1
EXIT/B 0


:DEL_FAILED
ECHO Unable to delete one or more files. This could be a permissions problem.
ECHO.
PAUSE
:FINISHED
ECHO This script will now exit.
ECHO.
PAUSE
EXIT/B